#ifdef GL_ES
precision lowp float;
#endif
// Just for identification if this is our shader or not
uniform float heyclayshader;

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
uniform sampler2D u_texture;


void main()
{
    vec4 texColor = texture2D(u_texture, v_texCoord);
    
    float colorIntensity = (texColor[0] + texColor[1] + texColor[2]) / 3.0f;
    
    texColor[3] = texColor[3] * colorIntensity;
    texColor[0] = 1.0f;
    texColor[1] = 1.0f;
    texColor[2] = 1.0f;
    
    gl_FragColor = texColor;
    
}
