#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform sampler2D u_texture;
uniform vec2 blurSize;

void main()
{
    vec4 sum = vec4(0.0);
    vec2 texOffset = 1.0 / vec2(textureSize(u_texture, 0));

    for (int x = -4; x <= 4; x++)
    {
        for (int y = -4; y <= 4; y++)
        {
            vec2 offset = vec2(x, y) * blurSize;
            sum += texture2D(u_texture, v_texCoord + texOffset * offset);
        }
    }

    gl_FragColor = sum / 81.0; // Adjust the denominator for the desired blur intensity
}
