#ifdef GL_ES
precision lowp float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
uniform sampler2D u_texture;
uniform int u_enabled;

void main(void)
{
    
    vec4 c = texture2D(u_texture, v_texCoord);
    
    if(u_enabled == 0) {
        gl_FragColor = c;
    } else {
        float gray = 0.2126*c.r + 0.7152*c.g + 0.0722*c.b;
        // increasing brightdness by 20%
        float koef = 0.2;
        float dark = 1.0 / gray;
        // the darker color - the more increased brightness
        float lightenKoef = 1.0 + koef * dark;
        gray = gray * lightenKoef;
        // Ensure the value does not exceed 1.0
        gray = min(gray, 1.0);
        gl_FragColor = vec4(vec3(gray), c.w);
    }
    
}
