#ifdef GL_ES
precision lowp float;
#endif
// Just for identification if this is our shader or not
uniform float heyclayshader;

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
uniform sampler2D u_texture;

uniform vec4 startColor;
uniform vec4 endColor;
uniform int useAlphaUniform;
uniform float alpha;

void main()
{
    
    vec4 texColor = texture2D(u_texture, v_texCoord);

    float weight = 0.33 * texColor.r + 0.5 * texColor.g + 0.16 * texColor.b;
    vec4 gradientColor = mix(startColor, endColor, weight);
    gradientColor.a = texColor.a;
    if(useAlphaUniform != 0) {
        gradientColor.a = gradientColor.a * alpha;
    }
    
    gl_FragColor = gradientColor;
}
