#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform vec2 resolution;
uniform vec2 centerStart;

uniform vec4 startColor;
uniform vec4 endColor;


uniform sampler2D u_texture;

void main()
{
    vec2 transformedCenterStart = vec2(centerStart.x, 1.0 - centerStart.y);
    vec2 center = resolution * transformedCenterStart;
    vec2 position = v_texCoord * resolution;
    // Calculate the center of the sprite
    
    float distance = distance(position, center);

    // Calculate the interpolation factor based on the distance
//    float t = distance / length(center);
    float t = distance / (resolution.y * 0.6);
    clamp (t, 0.0, 1.0);

    // Interpolate the color
    vec4 color = mix(startColor, endColor, t);

    gl_FragColor = color;
}

