#ifdef GL_ES
precision lowp float;
#endif
// Just for identification if this is our shader or not
uniform float heyclayshader;

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
uniform sampler2D u_texture;

uniform vec4 startColor;
uniform vec4 intermediateColor;
uniform vec4 endColor;
uniform float colorWeight;

void main()
{
    vec4 texColor = texture2D(u_texture, v_texCoord);

    float weight = 0.33 * texColor.r + 0.33 * texColor.g + 0.33 * texColor.b;

    float normStartColorWeight = clamp( (weight / colorWeight), 0.0, 1.0 );
    float normEndColorWeight = clamp( ((weight - colorWeight) / (1.0 - colorWeight)), 0.0, 1.0);
    
    vec4 gradientColor = mix(startColor, intermediateColor, normStartColorWeight);
    vec4 gradientColor1 = mix(gradientColor, endColor, normEndColorWeight);
    
    gradientColor1.a = texColor.a;
    gl_FragColor = gradientColor1;
    
}
