#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
uniform sampler2D u_texture;
uniform vec4 startColor;
uniform vec4 endColor;
uniform float startPosition;
uniform float endPosition;

void main()
{
    vec4 color = texture2D(u_texture, v_texCoord);
    float alpha = color.a;
    
    // Calculate the position of the current pixel along the Y-axis
    float positionY = v_texCoord.y;
    
    // Interpolate between the top and bottom colors based on the Y position
    if (positionY < startPosition)
    {
        color = startColor;
    }
    else if (positionY > endPosition)
    {
        color = endColor;
    }
    else
    {
        float t = (positionY - startPosition) / (endPosition - startPosition);
        color = mix(startColor, endColor, t);
    }
    
    if(alpha < 0.01) color.a = alpha;

    
    gl_FragColor = color;
}

