#ifdef GL_ES
precision mediump float;
#endif

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform vec2 resolution;
uniform float blurRadius;
uniform float sampleNum;

uniform float startAlpha;
uniform float endAlpha;
uniform float startPosition;
uniform float endPosition;

uniform bool reverse;

uniform sampler2D u_texture;

vec4 blur(vec2);
vec4 handleTransparent(vec4);

void main(void)
{
    
    vec4 blurred = blur(v_texCoord) * v_fragmentColor;
    
    vec4 transparentAndBlured = handleTransparent(blurred);
    
    gl_FragColor = transparentAndBlured;
}

vec4 blur(vec2 p)
{
    if (blurRadius > 0.0 && sampleNum > 1.0)
    {
        vec4 col = vec4(0);
        vec2 unit = 1.0 / resolution.xy;

        float r = blurRadius;
        float sampleStep = r / sampleNum;

        float count = 0.0;

        for (float x = -r; x < r; x += sampleStep)
        {
            for (float y = -r; y < r; y += sampleStep)
            {
                float weight = (r - abs(x)) * (r - abs(y));
                vec2 offset = vec2(x * unit.x, y * unit.y);
                vec4 texColor = texture2D(u_texture, p + offset);
                
                // Check if the pixel is semi-transparent
                if (texColor.a < 0.5)
                {
                    texColor.rgb = vec3(1.0); // Replace RGB with white color for semi-transparent pixels
                }
                
                col += texColor * weight;
                count += weight;
            }
        }

        return col / count;
    }

    return texture2D(u_texture, p);
}

vec4 handleTransparent(vec4 p)
{
    vec4 color = p;
    float alpha = color.a;

    // Calculate the position of the current pixel along the Y-axis
    float positionY = v_texCoord.y;

    // Interpolate between the top and bottom colors based on the Y position
    if(reverse) {
        if (positionY < startPosition)
        {
            color.a = color.a * endAlpha;
        }
        else if (positionY > endPosition)
        {
            color.a = color.a * startAlpha;
        }
        else
        {
            float t = 1.0 - abs(positionY - startPosition) / abs(endPosition - startPosition);
            float newAlpha = startAlpha + (endAlpha - startAlpha) * t;
            color.a = color.a * newAlpha * newAlpha;
        }
    } else {
        if (positionY < startPosition)
        {
            color.a = color.a * startAlpha;
        }
        else if (positionY > endPosition)
        {
            color.a = color.a * endAlpha;
        }
        else
        {
            float t = abs(positionY - startPosition) / abs(endPosition - startPosition);
            float newAlpha = startAlpha + (endAlpha - startAlpha) * t;
            color.a = color.a * newAlpha * newAlpha;
        }
    }

    return color;
    
}

