#ifdef GL_ES
precision lowp float;
#endif

varying vec2 v_texCoord;
uniform sampler2D u_texture;
uniform sampler2D u_maskTexture;
uniform vec2 u_maskScale;
uniform vec2 u_maskSize;
uniform vec2 u_spritePosition;

void main()
{
    vec4 color = texture2D(u_texture, v_texCoord);
    
    vec2 maskCenter = u_maskSize / 2.0;
    vec2 maskTexCoord = v_texCoord * u_maskScale - (u_maskScale - 1.0) * maskCenter;
    maskTexCoord = maskTexCoord - u_spritePosition;
    vec4 mask = texture2D(u_maskTexture, maskTexCoord);

    if (mask.a == 0.0)
    {
        discard;
    }

    gl_FragColor = color * mask.a;  // Apply the mask alpha to the sprite color
}
