#ifdef GL_ES
precision lowp float;
#endif
// Just for identification if this is our shader or not
uniform float heyclayshader;
uniform float white_percent;

varying vec4 v_fragmentColor;
varying vec2 v_texCoord;
uniform sampler2D u_texture;


void main()
{
    vec4 texColor = texture2D(u_texture, v_texCoord);
    
    float rDelta = (1.0f-texColor[0]) * white_percent;
    float gDelta = (1.0f-texColor[1]) * white_percent;
    float bDelta = (1.0f-texColor[2]) * white_percent;
    
    float r = clamp(texColor[0] + rDelta, 0.0f, 1.0f);
    float g = clamp(texColor[1] + gDelta, 0.0f, 1.0f);
    float b = clamp(texColor[2] + bDelta, 0.0f, 1.0f);
    
    texColor[0] = r;
    texColor[1] = g;
    texColor[2] = b;
    
    gl_FragColor = texColor;
    
}
